import React, {Component} from 'react';

import Ionicon from "react-ionicons";
import {Tooltip} from "reactstrap";

export default class AcquaticaDrop extends Component {

    constructor(props) {
        super(props);

        this.state = {
            tooltipOpen: false,
        };

        this.toggleTooltip = this.toggleTooltip.bind(this);
    }

    toggleTooltip() {
        this.setState({tooltipOpen: !this.state.tooltipOpen});
    }

    render() {
        const {row} = this.props;
        let acquatica, id;

        if(row) {
            acquatica = row.original.acquatica;
            id = row.original.id;
        } else {
            acquatica = this.props.acquatica;
            id = this.props.specieId
        }

        if(acquatica === "true") {
            return(<span style={this.props.containerStyle}>
                <span id={"drop-specie-acquatica-" + id}>
                    <Ionicon style={{verticalAlign:'middle'}} icon="ios-water" color="#007bff" />
                </span>
                <Tooltip target={"drop-specie-acquatica-" + id} delay={0} placement="right" isOpen={this.state.tooltipOpen} toggle={this.toggleTooltip}>
                    Questa è una specie acquatica
                </Tooltip>
            </span>);
        } else {
            return(<div>{}</div>);
        }
    }
}